using System.Net;
using System.Net.Sockets;
using System.Threading;
using gov.va.med.VBECS.Communication.Channels;
using gov.va.med.VBECS.Communication.Common;
using gov.va.med.VBECS.Communication.Protocols;
using gov.va.med.vbecs.DAL.VistALink.Client;
#if NUNIT
#region Directives
//-----------------------***
using System;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;
using gov.va.med.vbecs.DAL.VAL;
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***

#endregion
namespace gov.va.med.vbecs.UnitTest.VAL
{
	[TestFixture]
	public class ValVistALinkPing : BaseTest
    {
        #region Mock Classes

	    private class MockTcpChannel : TcpChannel
	    {
	        public MockTcpChannel(Socket theClientSocket) : base(theClientSocket)
	        {
	        }

	        protected override void SendImpl(IMessage aMessage)
	        {
                throw new CommunicationException("Test Exception");
	            //base.SendImpl(aMessage);
	        }
	    }

	    private class MockTcpClient : VBECS.Communication.Clients.TcpClient<MockPinger>
	    {
            private readonly IPEndPoint _serverEndPoint;

            public MockTcpClient(IPEndPoint theServerEndPoint)
                    : base(theServerEndPoint, new MessagesProtocolEot(null, new VistaLinkMessageFactory()))
            {
                _serverEndPoint = theServerEndPoint;
            }

	        protected override IChannel CreateCommunicationChannel()
	        {
                return new MockTcpChannel(ConnectToEndPoint(_serverEndPoint, ConnectTimeout));
	        }
	    }

	    #endregion

        private string _outErrorMessage;

		[SetUp]
		protected void SetUp()
		{
			BaseSetUp();

			_outErrorMessage = null;
			VistALinkUnitTestHarness.ReleaseConnection(); 
		}

		[TearDown]
		protected void TearDown()
		{
			_outErrorMessage = null;
			VistALinkUnitTestHarness.ReleaseConnection(); 
		}

        [Test]
        public void PingFail2()
        {
            var connection = VistALinkUnitTestHarness.GetUnitTestVistALinkConfig().GetServerConnectionInfo();
            var vlConnection = new VistALinkClientConnection(connection,
                new MockTcpClient(new IPEndPoint(connection.IPAddress, connection.PortNumber)));

            vlConnection.Connect();
            Thread.Sleep(20000);
            Assert.IsFalse(vlConnection.IsConnected);
            vlConnection.Dispose();
        }

		[Test]
		public void Ping_Pass()
		{	
			Assert.IsTrue( VistALinkPing.Ping( VistALinkUnitTestHarness.GetUnitTestVistALinkConfig().GetServerConnectionInfo(), out _outErrorMessage ) );
			Assert.IsNull( _outErrorMessage );
		}

		[Test]
		public void Ping_Pass_2()
		{
			Assert.IsTrue( !VistALinkPing.Ping( new ServerConnectionInfo( "127.0.0.01", 65000 ), out _outErrorMessage ) );
			Assert.IsNotNull( _outErrorMessage );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void Ping_Fail()
		{
			VistALinkPing.Ping( null, out _outErrorMessage );
		}
	}
}
#endif
